require( "scripts/game/deftasks.lua" );
require( "scripts/game/deftime.lua" );
require( "scripts/game/defpersonage.lua" );
--  "mother"
GameObject = {
-- main parameters
    Params = {
        ID="mother";       --    (,   ,  )
        width=1;           --   (      )
        height=1;          --    (      )
        speed=800;         --   
        LemonadWork=0.7;    --       .     
        drink_speed_bonus = 1.7;
        lemonad_time = 10;
        --     ,     
        group=1;
        timerTask=-1;
        bonus_it = 0;
        GridData = { 1 };
        idle_timer = { 3, 8, 10 }; --         -          
        idle_animation = { 100, 100, 100, 100 }; --  ,  -  -   
        home = true;
        enabled = 0;        -- do not change this parameter(  )
    };
    Objects = {};
    -- list of all tasks for an object
    --  'timer'     
    Tasks = { 
        eating   = { FuncName="eatingExecute", timer = 3 }; 
        watering = { FuncName="wateringExecute", timer = 3}; 
        eating_cow_end   = { FuncName="endEatingCowExecute",   timer = 5}; 
        milking_cow   = { FuncName="milkingCowExecute",   timer = 5}; 
        watering_cow_end   = { FuncName="endWateringCowExecute",  timer = 5}; 
        eating_sheep_end   = { FuncName="endEatingSheepExecute", timer = 3}; 
        shearing_sheep   = { FuncName="shearingSheepExecute", timer = 3}; 
        watering_sheep_end   = { FuncName="endWateringSheepExecute", timer = 2 }; 
        talk_telephon = { FuncName="TalkTelephonExecute", timer = {6,5}};      
        talk_brother = { FuncName="TalkMobilaExecute", timer = {6,5}};      
        mother_home_mhp = { FuncName="MotherGoHomeExecute", timer = {1}, hand_add=1};
        tools_sheep_end   = { FuncName="endCleaningSheepExecute",   timer = 3 }; 
        tools_cow_end   = { FuncName="endCleaningCowExecute",   timer = 3 }; 
        eating_hen_end   = { FuncName="endEatingHenExecute",   timer = 2, time_tick=300 }; 
        egging_hen   = { FuncName="eggingHenExecute",      timer = 8 }; 
        watering_hen_end   = { FuncName="endWateringHenExecute",   timer = 2 }; 
        --Tomato
        tools_tomato_end   = { FuncName="endFertilizingTomatoExecute",   timer = 3 };         
        watering_tomato_end   = { FuncName="endWateringTomatoExecute",   timer = 3 };         
        weeding_tomato = { FuncName="WeedingTomatoExecute", timer = 4 };        
        collection_tomato = { FuncName="CollectionTomatoExecute", timer=5 };
        --
        weeding_ground = { FuncName="WeedingGroundExecute", timer = 4, time_tick=600 };        
        tools   = { FuncName="TakeToolsExecute",  timer = 2 }; 
        tools_ground_end   = { FuncName="endPlantGroundExecute",  timer = 5 }; 
        --eatmachine
        eating_eatmachine_end = { FuncName="switchOnEatMachineExecute",  timer = 1 }; 
        --trash
        trashing_trash_end = { FuncName="trashingExecute",     timer = 1,  time_tick=200 }; 
        --  
        eggtake = { FuncName="eggtakeExecute",     timer = 1,  time_tick=100 }; 
        milktake = { FuncName="milktakeExecute",     timer = 1,  time_tick=100 }; 
        sheartake = { FuncName="sheartakeExecute",     timer = 1,  time_tick=100 }; 
        tomatostake = { FuncName="tomatostakeExecute",     timer = 1,  time_tick=100 }; 
        cornstake = { FuncName="cornstakeExecute",     timer = 1,  time_tick=100 }; 
        milkgoattake = { FuncName="milkgoattakeExecute",     timer = 1,  time_tick=100 }; 
        cheesetake = { FuncName="cheesetakeExecute",     timer = 1,  time_tick=100 }; 
        keeping_redbarn_end = { FuncName="keepingRedbarnExecute",     timer = 1,  time_tick=1300 }; 
        relax_kreslo = { FuncName="RelaxInKreslo", timer=3, time_tick=1000, hand_add=1 };
        --
        eating_goat_end   = { FuncName="endEatingGoatExecute",   timer = 3 }; 
        milking_goat   = { FuncName="milkingGoatExecute",      timer = 8 }; 
        watering_goat_end   = { FuncName="endWateringGoatExecute",   timer = 3 }; 
        
        make_lemonad = { FuncName="MakeLemonadExecute",   timer = 1 }; 
        drink_lemonad = { FuncName="DrinkLemonadExecute", timer = 2, hand_add=1};        
        switch_on_cheesemachine_end = { FuncName="switchCheeseMachExecute",     timer = 1,  time_tick=100 }; 
        --corn
        watering_corn_end   = { FuncName="endWateringCornExecute",   timer = 3 };         
        tools_corn_end = { FuncName="endFertilizingCornExecute",   timer = 3 };         
        weeding_corn = { FuncName="WeedingTomatoExecute", timer = 4 };        
        collection_corn = { FuncName="CollectionTomatoExecute", timer=5 };
        
        watering_pumpkins_end   = { FuncName="endWateringPumpkinsExecute",   timer = 2,time_tick=500  };         
        tools_pumpkins_end = { FuncName="endFertilizingPumpkinsExecute",   timer = 3 };         
        weeding_pumpkins = { FuncName="WeedingPumpkinsExecute", timer = 3, time_tick=300   };        
        collection_pumpkins = { FuncName="CollectionPumpkinsExecute", timer=5 };
        
        pumpkintake = { FuncName="pumpkintakeExecute",     timer = 1,  time_tick=100 }; 
        
    };
--       ,     
------------------------------------------------------------------------------------------------------------------------------------------------------------------------
    -- list of all triggers for an object
    Triggers = {
        drink_triger = {FuncName="DrinkTriger"};                    
        --TalkTelephone = { FuncName="TalkTelephoneTriger",NotRunWhen={}, timer={ 35,45 }, first_timer={ 10,32 }, cur_value=0 };       
    };
    --tasks to be performed after an object is created
    InitActiveTasks = {}; 
    --tasks an object is waiting ofr after it is created
    InitExpectedTasks = {};
};

--  
function GameObject:Get()
    return self;
end
--   
function GetParams()
    aObj = GameObject:Get();   
    return aObj.Params;
end

-- perform Task EATING over external object and return true if task is completed
function eatingExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eating.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;

    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if task is completed
function milkingCowExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.milking_cow.timer; 
        CPP_SecondObjChildAnimState("milk","milk",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjChildAnimState("milk","milk",2,0);
    end
    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("milk","milk",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("milking",aObject.Tasks.milking_cow);                     
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if  task is completed
function shearingSheepExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.shearing_sheep.timer; 
        CPP_SecondObjChildAnimState("shear","shear",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then CPP_SecondObjChildAnimState("shear","shear",2,0); end
    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("shear","shear",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("shearing",aObject.Tasks.shearing_sheep);                             
        return 0;
    end
    return 1;
end
--    Task WATERING       true  
function endWateringSheepExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_sheep_end.timer; 
        CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_sheep_end);                                             
        return 0;
    end
    return 1;
end



--   
function TalkTelephoneTriger()
    aObj = GameObject:Get();
    return defWishTriger(aObj.Triggers.TalkTelephone, "talk",1 );
end
--     
function MotherGoHomeExecute()
    aObject = GameObject:Get();
    CPP_Sleep(10000,1);
    aObject.Params.timerTask = -1;
    return 0;
end
-- TOMATO
--    Task WATERING       true  
function endWateringTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_tomato_end.timer; 
        CPP_PlaySound("water_pour",0);        
        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_tomato_end);                                             
        return 0;
    end
    return 1;
end

--    Task WATERING       true  
function WeedingTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.weeding_tomato.timer; 
        CPP_PlaySound("weeding",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("weeding",aObject.Tasks.weeding_tomato);                             
        CPP_StopSound("weeding");
        return 0;
    end
    return 1;
end

function CollectionTomatoExecute()
    return DefCollectionExecute("collection_tomato", "tomatos");
end
--  
--   Task EATING      true  
function endEatingHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.eating_hen_end.timer; 
        CPP_PlaySound("hay",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjAnimState("nasip_seno2");
    else 
        if (tTask == 1) then 
            CPP_SecondObjAnimState("nasip_seno1");
        else 
            CPP_SecondObjAnimState("eating_hen"); 
        end
    end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        OnEndTask("eating",aObject.Tasks.eating_hen_end);             
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end


--    Task WATERING       true  
function endWateringHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_hen_end.timer; 
        CPP_SecondObjAnimState("watering_hen");
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_hen_end);                                             
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if  task is completed
function eggingHenExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_SecondObjChildAnimState("egg","egg",1,0);
        tTask = aObject.Tasks.egging_hen.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjChildAnimState("egg","egg",2,0);
    end
    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("egg","egg",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("egging",aObject.Tasks.egging_hen);                             
        return 0;
    end
    return 1;
end
-- perform Task over external object and return true if task is completed
function TakeToolsExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools.timer; 
        CPP_PlaySound("workshop_get_tools",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;

    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("tools",aObject.Tasks.tools);                     
        return 0;
    end
    return 1;
end

--   Task      true  
function endPlantGroundExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_ground_end.timer; 
        CPP_PlaySound("planting",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        OnEndTask("tools",aObject.Tasks.tools_ground_end);       
        return 0;
    end
    return 1;
end

function WeedingGroundExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        CPP_PlaySound("weeding",1);
        tTask = aObject.Tasks.weeding_ground.timer; 
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        OnEndTask("weeding_ground",aObject.Tasks.weeding_ground);                             
        CPP_StopSound("weeding");
        return 0;
    end
    return 1;
end

-- EATMACHINE
function switchOnEatMachineExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eating_eatmachine_end.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("left_stand");
        OnEndTask("eating_eatmachine_end",aObject.Tasks.eating_eatmachine_end);                       
        return 0;
    end
    return 1;
end

function trashingExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.trashing_trash_end.timer; 
        CPP_PlaySound("garbage",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end
--  
function keepingRedbarnExecute()
    return defKeepingRedbarnExecute();
end

function eggtakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.eggtake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function milktakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.milktake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function sheartakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.sheartake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function tomatostakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.tomatostake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function cornstakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.cornstake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function milkgoattakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.milkgoattake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        if (CPP_IsObjectExist("cheesemachine")) then
            CPP_AddRemittedTasks("mother","cheesemachine","","");   
        else
            CPP_AddRemittedTasks("mother","redbarn","","goatmilktake_task_icon");   
        end
        return 0;
    end
    return 1;
end

function cheesetakeExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then tTask = aObject.Tasks.cheesetake.timer; end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("right_stand");
        CPP_AddRemittedTasks("mother","redbarn","","");   
        return 0;
    end
    return 1;
end

function RelaxInKreslo()
    return DefRelaxTask("mother_rest");
end
---------------------------------------------------------------------------------------------------------------------------------------
--   Task EATING      true  
function endEatingGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.eating_goat_end.timer; 
        CPP_PlaySound("hay",0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 2) then 
        CPP_SecondObjAnimState("eating_sheep");
    else 
        if (tTask == 1) then 
            CPP_SecondObjAnimState("nasip_seno1");
        else 
            CPP_SecondObjAnimState("nasip_seno2"); 
        end
    end
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        OnEndTask("eating",aObject.Tasks.eating_goat_end);             
        CPP_SetAnimState("right_stand");
        return 0;
    end
    return 1;
end
-- perform Task MILKING  over external object and return true if  task is completed
function milkingGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.milking_goat.timer;
        CPP_SecondObjChildAnimState("milkgoat","milk",1,0);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    
    if (tTask == 2) then CPP_SecondObjChildAnimState("milkgoat","milk",2,0); end

    if (tTask <= 0) then
        CPP_SecondObjChildAnimState("milkgoat","milk",3,0);
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("selected");
        CPP_SetAnimState("right_stand");
        OnEndTask("milking",aObject.Tasks.milking_goat);                             
        return 0;
    end
    return 1;
end
--    Task WATERING       true  
function endWateringGoatExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering_goat_end.timer; 
        CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("water_pour",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("watering",aObject.Tasks.watering_goat_end);                                             
        return 0;
    end
    return 1;
end


function MakeLemonadExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.make_lemonad.timer;
        CPP_PlaySound("juicer",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        return 0;
    end
    return 1;
end

function switchCheeseMachExecute()
    CPP_SetAnimState("left_stand");
    return 0;
end

function endCleaningSheepExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_sheep_end.timer; 
        --CPP_SecondObjAnimState("watering_sheep");
        CPP_PlaySound("washing",1);
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_StopSound("washing");
        CPP_SetAnimState("up_stand");
        OnEndTask("tools",aObject.Tasks.tools_sheep_end);                                             
        return 0;
    end
    return 1;
end

function endCleaningCowExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_cow_end.timer; 
        CPP_PlaySound("washing",1);
        --CPP_SecondObjAnimState("watering_sheep");
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_StopSound("washing");
        CPP_SetAnimState("up_stand");
        OnEndTask("tools",aObject.Tasks.tools_cow_end);                                             
        return 0;
    end
    return 1;
end

function endFertilizingTomatoExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.tools_tomato_end.timer; 
        CPP_PlaySound("fertilizer",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("up_stand");
        OnEndTask("tools",aObject.Tasks.tools_tomato_end);                                             
        return 0;
    end
    return 1;
end

-- CORN
function endWateringCornExecute()
    return DefEndWateringExecute("watering_corn_end");
end

function endFertilizingCornExecute()
    return DefEndToolsExecute("tools_corn_end");
end

function WeedingCornExecute()
    return DefWeedingExecute("weeding_corn");
end

function CollectionCornExecute()
    return DefCollectionExecute("collection_corn", "corns");
end
------------------------------------------------------------------------------------------------------------------------------
-- Pumpkins
function endWateringPumpkinsExecute()
    return DefEndWateringExecute("watering_pumpkins_end");
end

function endFertilizingPumpkinsExecute()
    return DefEndToolsExecute("tools_pumpkins_end");
end

function WeedingPumpkinsExecute()
    return DefWeedingExecute("weeding_pumpkins");
end

function CollectionPumpkinsExecute()
    return DefCollectionExecute("collection_pumpkins", "pumpkin");
end
------------------------------------------------------------------------------------------------------------------------------
-- Pumpkin
function pumpkintakeExecute()
    return DefTakeExecute("pumpkintake");
end
-- perform Task WATERING  over external object and return true if task is completed
function wateringExecute()
    aObject = GameObject:Get();
    local tTask = aObject.Params.timerTask;
    if (tTask < 0) then 
        tTask = aObject.Tasks.watering.timer; 
        CPP_SetAnimState("watering_handcall");
        CPP_SecondObjAnimState("rolling");
        CPP_PlaySound("well",0);        
    end
    tTask = tTask - 1;
    aObject.Params.timerTask = tTask;
    if (tTask == 1) then CPP_SecondObjAnimState("rolling_end"); end;
    if (tTask <= 0) then
        aObject.Params.timerTask = -1;
        CPP_SetAnimState("left_stand");
        CPP_SecondObjAnimState("normal");
        return 0;
    end
    return 1;
end
